# Rimworld Hardcore SK v.1.5

[![Logo](https://i.imgur.com/WP7w2sM.png)](https://github.com/skyarkhangel/Hardcore-SK)
<!-- you cant center markdown images -->

**Discord:** <https://discord.gg/vTJ6fnAeyA> **(Validated Account Required)**

First, I would like to thank the artists and developers of all the mods used in Hardcore SK.

Rimworld is about telling a story - about overcoming difficulties which your colonists will encounter on a mostly-untamed planet. The more variety of challenges they face, the more interesting your story will be, and this is what makes Rimworld worth playing again and again.

The idea for this project came to me after playing with mod packs. I discovered that although there are many great mods out there, game balance becomes messy and there are often bugs and incompatabilities when they're all played together. Hardcore SK offers a carefully curated list of mods which are optimized, balanced and maintained by myself and a team of modders, in additional to an abundance of original content which we continuously create.

The focus of Hardcore SK is to add a growing complexity to gameplay while immersing the player deep in the story. What awaits you is an improved and elaborate production chain, over 100 technologies to research, new events and challenges to face, impressive new foods, wardrobe and arsenal, enhanced AI features, quality of life options, and virtually everything retextured. As soon as you make landfall, you'll understand immediately that this is no longer just modded Rimworld - this is Hardcore SK. The campfire welcomes you.

This project has language support for English, Russian, and partial support for Spanish and Korean. Chinese translation available via separate mods: [Core](https://steamcommunity.com/sharedfiles/filedetails/?id=2469653495) & [Everything else](https://steamcommunity.com/sharedfiles/filedetails/?id=2469654237).

## DOWNLOADING

### Project launcher (Windows only)

* **Download:** <https://github.com/HardcoreSK/HSK-Launcher/releases/latest>

#### Features

* Update HSK (Hardcore SK) in just a few clicks!
* Built-in proxy if github is unavailable.
* Optional ModsConfig update if needed.
* Launch game via Steam or from custom location.
* Ability to check for new updates at startup.
* Install HSK from archive (if you need some specific version).

#### Requirements

- Launch Rimworld once to generate necessary folders and configuration files.
- .Net 6 Desktop Runtime (installed by windows Update Center starting with Windows 10).

Launcher will ask for the RimWorld executable location.

For Windows users:

* Steam usually stores it in `C:\Program Files (x86)\Steam\steamapps\common\RimWorld\RimWorldWin64.exe`

### Manual installation

[Master:](https://github.com/skyarkhangel/Hardcore-SK/tree/master) - The stable version/branch of the project usually a version behind the latest Rimworld. Currently for version 1.5.

[Development:](https://github.com/skyarkhangel/Hardcore-SK/tree/development) - The work-in-progress version which contains the latest content for the latest version of rimworld, but is more likely to contain bugs. Already for latest version 1.5.

1. Install either the [development](https://github.com/skyarkhangel/Hardcore-SK/tree/development) branch for version 1.5 Development or [master](https://github.com/skyarkhangel/Hardcore-SK/tree/master) for 1.4.

2. Go to the folder you installed the game in and delete all mods inside your `Rimworld\Mods\` folder.

3. Open up the downloaded Hardcore SK .zip file. Extract everything in the `Hardcore-SK-master\Mods\` OR `Hardcore-SK-Development\Mods\` OR `Hardcore-SK-Alpha\Mods\` folder into your empty `Rimworlds\Mods\` folder.

4. Go to the RimWorld config folder and delete all the files that exist in that folder. And Copy all config files inside the `Config` Folder we provide into that folder too. Do also copy the `Character Editor` folder into the same directory the `Config` folder is in.

For Windows users:

* `C:\Users\your user name\AppData\LocalLow\Ludeon Studios\RimWorld by Ludeon Studios`
* Or `windows button + R` -> the Run dialog will appear and then type `%APPDATA%\..\LocalLow` -> this will open the appdata folder

For Linux users: `/home/your user name/.config/unity3d/Ludeon Studios/RimWorld`

For Mac users: `/Users/your user name/Library/Application Support/RimWorld`

6. Copy folders `Config` and `Character Editor` from the root of the archive into `%userprofile%\appdata\locallow\Ludeon Studios\RimWorld by Ludeon Studios` or whatever directory is your Rimworld config folder. 

7. Copy `ModsConfig.xml` from the root of the archive into `Config` folder. 

7. Check mods at the title screen - turn on optional mods or disable ones you don't want. Switch Language if needed. Play!

8. Have fun 😀  

## Looking for even more content?

These are some extensive and unique mods which are not derivative of others and are specifically designed to work alongside HSK:

* Vile's Mods <https://github.com/xenomacabre/VilesMods> (several overhaul mods)
* Parabellum <https://github.com/Xx-Nelson-xX/Parabellum> (combat mod by Xx-Nelson-xX)
* Minerals Extra <https://github.com/zachary-foster?tab=repositories&q=Minerals&type=&language=&sort=> (more minerals content by Dusty Breeches)

The HSK community also manages a list of mods which can be found on our Discord channel:

* **Known Compatible Optional Mods:** <https://discord.com/channels/272340793174392832/1029866379974803468>
* **Patched Optional Mods:** <https://discord.com/channels/272340793174392832/1029833992385597522>

Other mods which are not included in this project are not recommended.

## Credits

A big thank you to the Patreons! (<https://www.patreon.com/skyarkhangel>, in no particular order.)

Szara Kryik, Sonsalt, Makzilla, Schio, GuiltyHollow, ErdTod, Sol, Tie, Zachary F, Fsempri, Andrey, Dudok22, Hoouin K, PuffTheMagicDragon,
PatchDotExe, Cawi, XLegionX007, НечтоХрустящее, Kristijan, sKeptr, White Sonja, Esterior, Igor Barbarossa, Kiko20, Ky6000, 
NiciusB, plenumolog, томαѕz, Dan Rowan, dissolvedz, Erilaz, Fsempri, GuardianDll, Kage No Ryuu, Titan399, zaartix, Zag, Нея, CADUCTO, 
JailBot, Dibbura, donnie, ignorer, korovyev, NiciusB, Nightray, Vuursteen and Егор Х!

### SK Team

* **Lead developers** - Skyarkhangel, TheLoneTec
* **Coordinators** - Zakhad, Sidfu, Dzeniba, A.Ziemens(Duotian)
* **Discord moderators** - Ziemens, MightyGooga, GG, Szara Kryik, Ashardalon, Xx-Nelson-xX, AndreiAvinov (Kiri), GuardianDll, Pacas
* **Artists** - Cattleya (<https://www.patreon.com/cattleya>), Vile Heathen
* **Coders** - Jeremy(PirateBY), TGC, Void, Dusty Breeches, Glucocorticoid, qwerty19106, AndreiAvinov (Kiri), MasakiTenchi 
* **XML modders** - Sidfu, ArpoMo6, GuardianDll, Spaniard829, Vile Heathen, Pacas, Xx-Nelson-xX

### Special thanks to

SpoonShortage, Mrofa, Fluffy, Zhentar, Brrainz, Dubwise, Erdelf, Greeny, Hunt3rKill3r, 
Lambert2191, Vuursteen, Tuvia, Dunkhan, jnkyacc, Jalordon, Varmonger, funs777, olizit, 
Quelling, pongvin, lex1975, evgeny-k, Moon, Leiarr, Voker57, Pardonius,
 Sonsalt, Rhyssia, Adenia, Abhay (artwork), ApelAirplane (artwork),
SomethingCrunchy (dev), NotFood (dev), Murdantiks, Adenia, Soyaman, Tombomcbombo, LimeTreeSnake, Raseri13

Thanks to translators Rey, Ivanzyfer, FaHT1k, mora145, totobrother, Desert Rain

And to anyone else we might have missed!

## LICENSE

The content of all individual mods is licensed under their respective licenses.
